<?php

namespace App\Models\Users;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function tasks()
    {
        return $this->hasMany('TaskUsers', 'user_id');
    }

    public function documents()
    {
        return $this->hasMany('Document', 'user_id');
    }

    public function permissions()
    {
        return $this->hasMany('UserPermission', 'user_id');
    }

    public function chats()
    {
        return $this->hasMany('UserChats', 'user_id');
    }

    public function chatMessages()
    {
        return $this->hasMany('ChatMessages', 'user_id');
    }

    public function logs()
    {
        return $this->hasMany('UserLog', 'user_id');
    }

    public function links()
    {
        return $this->hasMany('Links', 'user_id');
    }

}